	
	--Get ID of TBI registry for adding to new survey type column
	declare @registryID int, @executeString varchar(750)
	SELECT @registryID =  (SELECT ID [dbo.STD_Registry]
			FROM dbo.STD_Registry
			WHERE CODE = 'TBI');



IF NOT EXISTS(SELECT * FROM sys.columns 
            where Name = N'REGISTRY_ID' and Object_ID = Object_ID(N'STD_SURVEY_TYPE'))
BEGIN
	PRINT 'Adding REGISTRY_ID column, DF_STD_SURVEY_TYPE_REGISTRY_ID Constraint, and FK_REGISTRY_ID Foreign Key to Table STD_SURVEY_TYPE' + CHAR(13);
	SET @executeString = 'ALTER TABLE [dbo].[STD_SURVEY_TYPE] ADD REGISTRY_ID INT NOT NULL CONSTRAINT DF_STD_SURVEY_TYPE_REGISTRY_ID DEFAULT ' + CAST(@registryID as varchar(10))
	EXECUTE (@executeString)
	ALTER TABLE [dbo].[STD_SURVEY_TYPE] ADD CONSTRAINT FK_REGISTRY_ID FOREIGN KEY (REGISTRY_ID) REFERENCES STD_REGISTRY(ID)
END
ELSE
BEGIN
	PRINT 'REGISTRY_ID column already exists in table STD_SURVEY_TYPE' + CHAR(13);
END 

